; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = "some_name"
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands are given below. Delete, add, or modify as you wish.

;-| Super Motions |--------------------------------------------------------

; Technologic Shot SDM
[Command]
name = "ShotSDM"
command = ~D, DF, F, D, DF, F, b+y
time = 20

; Technologic Shot DM
[Command]
name = "ShotDM"
command = ~D, DF, F, D, DF, F, b
time = 20

; Technologic Shot DM
[Command]
name = "ShotDM"
command = ~D, DF, F, D, DF, F, y
time = 20

; Violent Tail Whip SDM
[Command]
name = "TailWhipSDM"
command = ~D, DF, F, D, DF, F, a+x
time = 20

; Violent Tail Whip DM
[Command]
name = "TailWhipDM"
command = ~D, DF, F, D, DF, F, a
time = 20

; Violent Tail Whip DM
[Command]
name = "TailWhipDM"
command = ~D, DF, F, D, DF, F, x
time = 20

;-| Special Motions |------------------------------------------------------
;-----------------
; Slash Tail Attack_a
[Command]
name = "Slash"
command = ~D, DF, F, a

; Slash Tail Attack_x
[Command]
name = "SlashH"
command = ~D, DF, F, x

; Miles Uppercut (light)
[Command]
name = "ShoryuL"
command = ~F, D, DF, a

; Miles Uppercut (hard)
[Command]
name = "ShoryuH"
command = ~F, D, DF, x

; Scissor_Punch_a
[Command]
name = "ScissorA"
command = ~D, DB, B, a

; Scissor_Punch_x
[Command]
name = "ScissorX"
command = ~D, DB, B, x

;Dash Propeller Attack (fraco)
[Command]
name = "chargebackfwd_a"
command = ~45$B, F, a
time = 10

; Dash Propeller Attack (forte)
[Command]
name = "chargebackfwd_x"
command = ~45$B, F, x
time = 10

;Sonic Slash
[Command]
name = "SlashA"
command = ~F, DF, D, a

;Sonic Slash X
[Command]
name = "SlashAX"
command = ~F, DF, D, x

;Spin Attack (weak)
[Command]
name = "SpinDash"
command = ~F, DF, D, a

;Spin Attack (strong)
[Command]
name = "SpinDash_S"
command = ~F, DF, D, x
;-----------------
;Charge_Down_up
[Command]
name = "chargedownup_a"
command = ~60$D, U, a
time = 10

[Command]
name = "chargedownup_b"
command = ~60$D, U, b
time = 10

[Command]
name = "chargedownup_x"
command = ~60$D, U, x
time = 10

[Command]
name = "chargedownup_y"
command = ~60$D, U, y
time = 10

;--------------------
;Charge_Back_fwd
[Command]
name = "chargebackfwd_a"
command = ~60$B, F, a
time = 10

[Command]
name = "chargebackfwd_b"
command = ~60$B, F, b
time = 10

[Command]
name = "chargedownup_x"
command = ~60$D, U, x
time = 10

[Command]
name = "chargedownup_y"
command = ~60$D, U, y
time = 10

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF";Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB";Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
Name = "Knock_Simple"
command = x+y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1

[Command]
name = "ab"
command = a+b
time = 1

[Command]
Name= "fab"
command = /$F,a+b
time = 1

[Command]
Name= "bab"
command = /$B,a+b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "fwd_a"
command = /F,a
time = 1

[Command]
name = "fwd_b"
command = /F,b
time = 1

[Command]
name = "fwd_c"
command = /F,c
time = 1

[Command]
name = "fwd_x"
command = /F,x
time = 1

[Command]
name = "fwd_y"
command = /F,y
time = 1

[Command]
name = "fwd_z"
command = /F,z
time = 1

[Command]
name = "back_a"
command = /B,a
time = 1

[Command]
name = "back_b"
command = /B,b
time = 1

[Command]
name = "back_c"
command = /B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_ab"
command = /F, a+b
time = 1

[Command]
name = "back_ab"
command = /B, a+b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "Provocate"
command = s

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd"  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup"   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "longjump"
command = D, $U
time = 18

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_yb"
command = /y+b
time = 30

[Command]
name = "hold_xa"
command = /x+a
time = 30

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 30

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 30

[Command]
name = "hold_z"
command = /z
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = "command_name"
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in. 


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
; SUPER MOTIONS
;===========================================================================
; Technologic Shot (SDM)
[State -1]
type = ChangeState
value = 3030
triggerall = RoundState = 2
triggerall = command = "ShotSDM"
triggerall = power  >= 2000
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 100

;---------------------------------------------------------------------------
; Technologic Shot (DM)
[State -1]
type = ChangeState
value = 3020
triggerall = RoundState = 2
triggerall = command = "ShotDM"
triggerall = power  >= 1000
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 100
;---------------------------------------------------------------------------
; Violent Tail Whip (SDM)
[State -1]
type = ChangeState
value = 3010
triggerall = RoundState = 2
triggerall = command = "TailWhipSDM"
triggerall = power  >= 2000
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = movecontact = 1
trigger4 = stateno = 220
trigger5 = movecontact = 1
trigger5 = stateno = 230
trigger6 = statetype = C
trigger6 = ctrl = 1
trigger7 = movecontact = 1
trigger7 = stateno = 400
trigger8 = movecontact = 1
trigger8 = stateno = 410
trigger9 = movecontact = 1
trigger9 = stateno = 420
trigger10 = movecontact = 1
trigger10 = stateno = 430
trigger11 = movecontact = 1
trigger11 = stateno = 1020
trigger12 = movecontact = 1
trigger12 = stateno = 1030
;---------------------------------------------------------------------------
; Violent Tail Whip (DM)
[State -1]
type = ChangeState
value = 3000
triggerall = RoundState = 2
triggerall = command = "TailWhipDM"
triggerall = power  >= 1000
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = movecontact = 1
trigger4 = stateno = 220
trigger5 = movecontact = 1
trigger5 = stateno = 230
trigger6 = statetype = C
trigger6 = ctrl = 1
trigger7 = movecontact = 1
trigger7 = stateno = 400
trigger8 = movecontact = 1
trigger8 = stateno = 410
trigger9 = movecontact = 1
trigger9 = stateno = 420
trigger10 = movecontact = 1
trigger10 = stateno = 430
trigger11 = movecontact = 1
trigger11 = stateno = 1020
trigger12 = movecontact = 1
trigger12 = stateno = 1030

;===========================================================================
; SPECIAL ATTACKS
;===========================================================================
;Miles Uppercut (hard)
[State -1]
type = ChangeState
value = 1030
triggerall = command = "ShoryuH"
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 420
trigger4 = movecontact = 1
trigger5 = stateno = 430
trigger5 = movehit = 1
;---------------------------------------------------------------------------
;Miles Uppercut (light)
[State -1]
type = ChangeState
value = 1020
triggerall = command = "ShoryuL"
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 400
trigger4 = movehit = 1
trigger5 = stateno = 420
trigger5 = movehit = 1
;---------------------------------------------------------------------------
;Dash Propeller Attack (weak)
[State -1]
type = ChangeState
value = 1100
triggerall = command = "chargebackfwd_a"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = statetype = C
trigger4 = ctrl = 1
trigger5 = movecontact = 1
trigger5 = stateno = 400
trigger6 = movecontact = 1
trigger6 = stateno = 410
;---------------------------------------------------------------------------
;Dash Propeller Attack (strong)
[State -1]
type = ChangeState
value = 1101
triggerall = command = "chargebackfwd_x"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 200
trigger3 = movecontact = 1
trigger3 = stateno = 210
trigger4 = statetype = C
trigger4 = ctrl = 1
trigger5 = movecontact = 1
trigger5 = stateno = 400
trigger6 = movecontact = 1
trigger6 = stateno = 410
;---------------------------------------------------------------------------
; Slash Attack (with X)
[State -1]
type = ChangeState
value = 1010
triggerall = command = "SlashH"
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 100

;---------------------------------------------------------------------------
; Slash Attack (with A)
[State -1]
type = ChangeState
value = 1000
triggerall = command = "Slash"
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 100
;---------------------------------------------------------------------------
; Scissor Punch (with X)
[State -1]
type = ChangeState
value = 1130
triggerall = command = "ScissorX"
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 100

;---------------------------------------------------------------------------
; Scissor Punch (with A)
[State -1]
type = ChangeState
value = 1120
triggerall = command = "ScissorA"
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 100

;---------------------------------------------------------------------------
; Sonic Slash
[State -1]
type = ChangeState
value = 1050
triggerall = command = "SlashA"
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 600
trigger3 = movehit = 1
trigger3 = stateno = 610
trigger4 = movecontact = 1
trigger4 = stateno = 620
trigger5 = movehit = 1
trigger5 = stateno = 630
;---------------------------------------------------------------------------
; Sonic Slash X
[State -1]
type = ChangeState
value = 1055
triggerall = command = "SlashAX"
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 600
trigger3 = movecontact = 1
trigger3 = stateno = 610
trigger4 = movecontact = 1
trigger4 = stateno = 620
trigger5 = movecontact = 1
trigger5 = stateno = 630
;---------------------------------------------------------------------------
; Spin Attack (weak)
[State -1]
type = ChangeState
value = 1060
triggerall = command = "SpinDash"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 400
trigger3 = movecontact = 1
trigger3 = stateno = 420
;---------------------------------------------------------------------------
; Spin Attack (strong)
[State -1]
type = ChangeState
value = 1070
triggerall = command = "SpinDash_S"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 400
trigger3 = movecontact = 1
trigger3 = stateno = 420
trigger4 = movecontact = 1
trigger4 = stateno = 410
trigger5 = movecontact = 1
trigger5 = stateno = 430
;---------------------------------------------------------------------------
;Standing_Knockdown_Attack (Normal_Command) 
[State -1]
type = ChangeState
value = 240
triggerall = command = "Knock_Simple"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 220
trigger2 = movehit = 1
trigger3 = stateno = 230
trigger3 = movehit = 1
;---------------------------------------------------------------------------
;===========================================================================
;RunFwd
[State -1]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;RunBack
[State -1]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Stand_Throw (close dir+b)
; Complicated? Skip the throws and look at stand_a, etc, first.
; This is disabled right now. Remove the "null;" below when you
; want to use it.
[State -1]
type = null; ChangeState
value = 900
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = p2bodydist X < 5 ;Near P2
trigger1 = command = "fwd_b";p2 stand
trigger1 = stateno != 100    ;Not running
trigger1 = p2statetype = S
trigger1 = p2movetype != H
trigger2 = command = "fwd_b";p2 crouch
trigger2 = stateno != 100    ;Not running
trigger2 = p2statetype = C
trigger2 = p2movetype != H
trigger3 = command = "back_b";p2 stand
trigger3 = p2statetype = S
trigger3 = p2movetype != H
trigger4 = command = "back_b";p2 crouch
trigger4 = p2statetype = C
trigger4 = p2movetype != H

;---------------------------------------------------------------------------
;Air_Throw1 (close dir+b)
; This is disabled right now. Remove the "null;" below when you
; want to use it.
[State -1]
type = null; ChangeState
value = 950
triggerall = statetype = A
triggerall = ctrl = 1
triggerall = p2bodydist X < 9
triggerall = p2bodydist Y > -22
triggerall = p2bodydist Y < 22
triggerall = p2statetype = A
triggerall = p2movetype != H
trigger1 = command = "fwd_b"
trigger2 = command = "back_b"

;===========================================================================
;---------------------------------------------------------------------------
;Forward Dodge 
[State -1]
type = ChangeState
value = 255
trigger1 = command = "fab"
trigger1 = stateno != 255
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Backward Dodge
[State -1]
type = ChangeState
value = 256
triggerall=command="bab"
triggerall = stateno != 256
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Provocate
[State -1]
type = ChangeState
value = 390
triggerall = Var(2) != 1
triggerall = command = "Provocate"
triggerall = Vel X = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
; BASIC ATTACKS
;---------------------------------------------------------------------------
;Stand Light Punch
[State -1]
type = ChangeState
value = 200
triggerall = command = "a";Place name of command here
triggerall = command != "holddown";Standing moves should have this line
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 100 
trigger3 = stateno = 200
trigger3 = time >= 7
;---------------------------------------------------------------------------
;Stand_Hard Punch
[State -1]
type = ChangeState
value = 210
triggerall = command = "x";Place name of command here
triggerall = command != "holddown";Standing moves should have this line
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 220
trigger3 = movehit = 1
trigger4 = stateno = 100
;---------------------------------------------------------------------------
;Stand_Light_Kick
[State -1]
type = ChangeState
value = 220
triggerall = command = "b";Place name of command here
triggerall = command != "holddown";Standing moves should have this line
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movehit = 1
trigger3 = stateno = 100 
;---------------------------------------------------------------------------
;Stand_Swing_Kick
[State -1]
type = ChangeState
value = 230
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 220
trigger2 = movecontact = 1
trigger3 = stateno = 100 
;---------------------------------------------------------------------------
;Standing_Knockdown_Attack (Simple_Button) 
[State -1]
type = ChangeState
value = 240
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 220
trigger2 = movehit = 1
trigger3 = stateno = 200
trigger3 = movehit = 1
;---------------------------------------------------------------------------
;Crouch_Light_Punch
[State -1]
type = ChangeState
value = 400
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = movehit = 1
trigger3 = stateno = 420
trigger4 = stateno = 400
trigger4 = time >= 7

;---------------------------------------------------------------------------
;Crouch_Light_Kick
[State -1]
type = ChangeState
value = 420
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 100
;---------------------------------------------------------------------------
;Crouch_Hard_Punch
[State -1]
type = ChangeState
value = 410
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 400
trigger3 = movehit = 1
trigger3 = stateno = 420
;---------------------------------------------------------------------------
;Crouch_Hard_Kick
[State -1]
type = ChangeState
value = 430
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 420
trigger3 = movecontact = 1
trigger3 = stateno = 400
;---------------------------------------------------------------------------
;Jump_Weak_Punch
[State -1]
type = ChangeState
value = 600
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Jump_Hard_Punch
[State -1]
type = ChangeState
value = 610
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 600
;--------------------------------------------------------------------------
;Jump_Weak_Kick
[State -1]
type = ChangeState
value = 620
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Jump_Heavy_Kick
[State -1]
type = ChangeState
value = 630
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = movecontact = 1
trigger2 = stateno = 620
;--------------------------------------------------------------------------